/* eslint-disable no-unused-vars */

const got = require('got');
const he = require('he');
const util = require('util');
const config = require('../../configs/current');
const locs = require('../../loc/social.json');
const getTld = require('../../lib/oldUtils').getTld;
const commonSetup = require('../commonSetup.js');
const {Validator} = require('express-json-validator-middleware');
const validator = new Validator({allErrors: true});
const {validate} = validator;
const schema = require('../schema.json');
const errorView = require('../../views/authzInWebError.js');
const formTryAgainView = require('../../views/formTryAgain.js');
const yr = require('yate/lib/runtime');
const client = require('../../lib/client');
const apiResponseError = require('./common/apiResponseError.js');
const generalError = require('./common/generalError.js');
const url = require('url');
const getPageContentByErrorCode = require('./common/getPageContentByErrorCode.js');

exports.route = function(app) {
    // app.use(config.path + '/authz_in_web', pino);
    app.get('/broker2/authz_in_web/:task_id/callback', this.callback);
};

exports.callback = [
    // TODO: validate({query: schema}),
    commonSetup,
    (req, res, next) => {
        return doRequest(req, res)
            .then(({body}) => {
                const {application_display_name, cancel_url, retry_url, cookies, location, status} = body;

                if (cookies) {
                    res.append('Set-Cookie', cookies);
                }

                if (status === 'redirect' && location) {
                    return res.redirect(location);
                }

                if (status === 'form_try_again') {
                    const lang =
                        (req.langdetect && ['ru', 'en', 'uk', 'tr'].includes(req.langdetect.id) && req.langdetect.id) ||
                        'ru';
                    const loc = locs[lang];
                    const content = util.format(
                        loc.common['authz_in_web_ensure_content'],
                        `<strong>${he.escape(application_display_name)}</strong>`
                    );

                    res.status(200).send(
                        yr.run('formTryAgain', {
                            content,
                            lang,
                            st_path: config.st_path,
                            windowHeight: 320,
                            windowWidth: 650,
                            i18n: loc,
                            passport: loc.common['title.passport'],
                            closeButton: loc.common['button.close'],
                            continueButton: loc.common['button.back'],
                            errorTitle: loc.common['authz_in_web_ensure_title'],
                            tld: getTld(req.hostname),
                            cancel_url,
                            retry_url,
                            uatraits: req.uatraits || {}
                        })
                    );
                }
            })
            .catch(next);
    },
    apiResponseError,
    generalError
];

function doRequest(req, res) {
    const {
        params: {task_id},
        originalUrl,
        headers: {'x-real-ip': user_ip},
        cookies: {Session_id, track}
    } = req;

    return client.call('/authz_in_web/callback', {
        method: 'POST',
        form: true,
        body: {
            query: url.parse(originalUrl).search.slice(1),
            task_id,
            track,
            Session_id,
            user_ip
        }
    });
}
