/* eslint-disable no-unused-vars */

const got = require('got');
const config = require('../../configs/current');
const locs = require('../../loc/social.json');
const getTld = require('../../lib/oldUtils').getTld;
const spinView = require('../../views/spin.js');
const bindView = require('../../views/bind.js');
const captchaView = require('../../views/captcha.js');
const errorView = require('../../views/error.js');
const indexView = require('../../views/index.js');
const commonSetup = require('../commonSetup.js');
const {Validator} = require('express-json-validator-middleware');
const validator = new Validator({allErrors: true});
const {validate} = validator;
const schema = require('../schema.json');
const yr = require('yate/lib/runtime');
const client = require('../../lib/client.js');
const getPageContentByErrorCode = require('./common/getPageContentByErrorCode.js');
const generalError = require('./common/generalError.js');
const apiResponseError = require('./common/apiResponseError.js');

var csrf = require('csurf');
var csrfProtection = csrf({
    cookie: true
});

exports.route = function(app) {
    app.get('/broker2/authz_in_web/:task_id/collect_diagnostics', this.bind);
};

exports.bind = [
    commonSetup,
    csrfProtection,
    (req, res, next) => {
        return doRequest(req)
            .then(({body: {status, location}}) => {
                if (status === 'redirect' && location) {
                    return res.redirect(location);
                }

                return next();
            })
            .catch(next);
    },
    apiResponseError,
    generalError
];

function doRequest(req) {
    const {
        params: {task_id},
        query,
        headers: {'x-real-ip': user_ip},
        cookies: {Session_id, track}
    } = req;

    return client.call('/authz_in_web/collect_diagnostics', {
        method: 'POST',
        form: true,
        query,
        body: {
            task_id,
            track,
            Session_id,
            user_ip
        }
    });
}
