/* istanbul ignore file */
/* eslint-disable no-unused-vars */

const yr = require('yate/lib/runtime');
const config = require('../../../configs/current');
const getTld = require('../../../lib/oldUtils').getTld;
const errorView = require('../../../views/authzInWebError.js');
const getPageContentByErrorCode = require('./getPageContentByErrorCode.js');
const locs = require('../../../loc/social.json');

module.exports = (error, req, res, next) => {
    const lang = (req.langdetect && ['ru', 'en', 'uk', 'tr'].includes(req.langdetect.id) && req.langdetect.id) || 'ru';
    const loc = locs[lang];

    if (error.name !== 'HTTPError') {
        return next(error);
    }

    const {
        body: {
            error: {code},
            retpath,
            request_id
        },
        statusCode
    } = error;

    const data = {};

    res.status(statusCode || 200).send(
        yr.run('authzInWebError', {
            closeButton: loc.common['button.close'],
            content: getPageContentByErrorCode(code, lang),
            errorTitle: loc.common['errror.title'],
            i18n: loc,
            lang,
            passport: loc.common['title.passport'],
            retpath,
            st_path: config.st_path,
            tld: getTld(req.hostname),
            request_id,
            windowHeight: 320,
            windowWidth: 650,
            uatraits: req.uatraits || {}
        })
    );
};
