/* istanbul ignore file */
/* eslint-disable no-unused-vars */

const yr = require('yate/lib/runtime');
const config = require('../../../configs/current');
const getTld = require('../../../lib/oldUtils').getTld;
const errorView = require('../../../views/authzInWebError.js');
const getPageContentByErrorCode = require('./getPageContentByErrorCode.js');
const locs = require('../../../loc/social.json');

module.exports = (error, req, res, next) => {
    const lang = (req.langdetect && ['ru', 'en', 'uk', 'tr'].includes(req.langdetect.id) && req.langdetect.id) || 'ru';
    const loc = locs[lang];

    let statusCode = 500;

    let message = error.message;

    if (error.name === 'JsonSchemaValidationError') {
        message = 'missed required query parameter';
        statusCode = 400;
    }

    if (error.name === 'ForbiddenError') {
        statusCode = 403;
    }

    res.status(statusCode).send(
        yr.run('authzInWebError', {
            lang,
            st_path: config.st_path,
            windowHeight: 320,
            windowWidth: 650,
            i18n: loc,
            errorTitle: loc.common['errror.title'],
            closeButton: loc.common['button.close'],
            tld: getTld(req.hostname),
            content: getPageContentByErrorCode(error.code, lang),
            request_id: `${message && message.split(' ').join('-')}-${new Date().getTime()}`,
            uatraits: req.uatraits || {}
        })
    );
};
