/* istanbul ignore file */

const locs = require('../../../loc/social.json');
const errorMsg = {
    DatabaseFailedError: 'internal-exception',
    InternalError: 'internal-exception',
    SessionInvalidError: 'integrity-data',
    YandexuidInvalidError: 'integrity-data',
    UserDeniedError: 'not_granted_access',
    ConsumerUnknownError: 'consumer-unknown',
    ProviderUnknownError: 'provider-unknown',
    ApplicationUnknownError: 'application-unknown',
    DisplayInvalidError: 'display-unknown',
    RetpathInvalidError: 'retpath-invalid',
    HostInvalidError: 'internal-exception',
    CommunicationFailedError: 'communication-failed',
    RateLimitExceededError: 'rate-limit',
    AuthorizationRequiredError: 'authorization-required',
    AccessTokenError: 'integrity-data',
    PkceCodeInvalidError: 'action_if_anonymous-invalid',
    PkceMethodInvalidError: 'action_if_anonymous-invalid'
};

function getPageContentByErrorCode(code, lang) {
    const loc = locs[lang];

    return loc.error[errorMsg[code] || errorMsg['InternalError']];
}

module.exports = getPageContentByErrorCode;
