/* eslint-disable no-unused-vars */

const got = require('got');
const config = require('../../configs/current');
const locs = require('../../loc/social.json');
const getTld = require('../../lib/oldUtils').getTld;
const spinView = require('../../views/spin.js');
const bindView = require('../../views/bind.js');
const captchaView = require('../../views/captcha.js');
const errorView = require('../../views/error.js');
const indexView = require('../../views/index.js');
const commonSetup = require('../commonSetup.js');
const {Validator} = require('express-json-validator-middleware');
const validator = new Validator({allErrors: true});
const {validate} = validator;
const schema = require('../schema.json');
const yr = require('yate/lib/runtime');
const client = require('../../lib/client');
const generalError = require('./common/generalError');
const apiResponseError = require('./common/apiResponseError');

exports.route = function(app) {
    app.get(`${config.path}/authz_in_web/start`, this.start);
};

exports.start = [
    commonSetup,
    validate({query: schema}),
    (req, res, next) => {
        return doRequest(req, res)
            .then(({body: {status, location, cookies}}) => {
                if (cookies) {
                    res.append('Set-Cookie', cookies);
                }

                if (status === 'redirect' && location) {
                    return res.redirect(location);
                }
            })
            .catch(next);
    },
    apiResponseError,
    generalError
];

function doRequest(req, res) {
    const {
        query: {application_name, consumer, retpath, flags, user_param},
        headers: {'x-real-ip': user_ip},
        cookies: {Session_id}
    } = req;

    return client.call('authz_in_web/start', {
        method: 'POST',
        form: true,
        body: {
            application_name,
            consumer,
            retpath,
            flags,
            Session_id,
            user_param,
            user_ip
        }
    });
}
