/* istanbul ignore file */

var config = require('../configs/current');
var langdetect = require('../lib/langDetect');
var uatraits = require('express-uatraits');
var blackbox = require('express-blackbox');

module.exports = [
    function(req, res, next) {
        if (req.cookies && req.cookies.Session_id) {
            return blackbox({
                api: config.blackbox
            })(req, res, next);
        }

        return next();
    },
    function(req, res, next) {
        if (req.blackbox && req.blackbox.status === 'VALID') {
            req.blackbox.dbfields = {
                'userinfo.lang.uid': req.blackbox.lang
            };
        }

        if (req.blackbox && req.blackbox.error !== 'OK') {
            console.log(
                'ERROR blackbox error',
                '[' + new Date() + ']',
                req.headers['x-real-ip'],
                req.headers['user-agent'],
                JSON.stringify(req.blackbox)
            );
        }

        return next();
    },
    langdetect({
        defaultLanguage: 'ru',
        availableLanguages: {
            az: ['ru', 'en'],
            'com.am': ['ru', 'en'],
            'com.ge': ['ru', 'en'],
            'co.il': ['en'],
            kg: ['ru', 'en'],
            lv: ['ru', 'en'],
            lt: ['ru', 'en'],
            md: ['ru', 'en'],
            tj: ['ru', 'en'],
            tm: ['ru', 'en'],
            uz: ['ru', 'en'],
            fr: ['en', 'ru', 'ua'],
            ee: ['ru', 'en'],
            ru: ['ru', 'uk', 'en'],
            ua: ['ru', 'uk', 'en'],
            by: ['ru', 'uk', 'en'],
            kz: ['ru', 'uk', 'en'],
            com: ['en', 'id', 'fr', 'fi'],
            'com.tr': ['tr', 'en'],
            default: ['ru', 'en', 'uk', 'tr']
        },
        geobaseVersion: 5,
        list: true
    }),
    uatraits({
        browser: '/usr/share/uatraits/browser.xml',
        profiles: '/usr/share/uatraits/profiles.xml',
        uatraits: '/usr/lib/node_modules/uatraits'
    })
];
