/* eslint-disable no-unused-vars */

var config = require('../configs/current');
var querystring = require('querystring');
var _ = require('lodash');
var urlFormat = require('url');
var yr = require('yate/lib/runtime');
var locs = require('../loc/social.json');
var getTld = require('../lib/oldUtils').getTld;
var url = config.url;
var pageData = {};
var loc;
var spinView = require('../views/spin.js');
var bindView = require('../views/bind.js');
var captchaView = require('../views/captcha.js');
var errorView = require('../views/error.js');
var indexView = require('../views/index.js');
var commonSetup = require('./commonSetup.js');
const fetch = require('../lib/fetch');

exports.route = function(app) {
    app.get(config.path + '/redirect', this.redirect)
        .get('/broker/redirect', this.redirect)
        .get(config.path + '/start', this.start)
        .get(config.path + '/authz_in_app/start', this.authzInAppStart)
        .get(config.path + '/*/callback', this.callback)
        .get(config.path + '/authz_in_app/*/callback', this.callback)
        .all(config.path + '/*/continue', this.continue)
        .get(config.path + '/authz_in_app/*/continue', this.continue)
        .get(config.path + '/*/retry', this.retry)
        .get(config.path + '/*/bind', this.bind)
        .get(config.path + '/tw_reverse_auth_token', this.reverse)
        .all(config.path + '/bind_by_token', this.bindByToken)
        .post(config.path + '/authz_in_app/entrust_to_account', this.authzInAppEntrustToAccount);
};

var defaultError = {
    error: {
        message: 'Failed to get data from backend',
        code: 'InternalError'
    }
};

var setup = [
    commonSetup,
    function(req, res, next) {
        res.locals.lang =
            (req.langdetect && ['ru', 'en', 'uk', 'tr'].includes(req.langdetect.id) && req.langdetect.id) || 'ru';
        loc = locs[res.locals.lang];

        pageData = {
            st_path: config.st_path,
            windowHeight: 320,
            windowWidth: 650,
            lang: res.locals.lang,
            i18n: loc,
            errorTitle: loc.common['errror.title'],
            passport: loc.common['title.passport'],
            closeButton: loc.common['button.close'],
            tld: getTld(req.hostname)
        };

        if (req.uatraits) {
            pageData.uatraits = req.uatraits;
        }

        res.set({
            'X-Content-Type-Options': 'nosniff',
            'X-Frame-Options': 'Deny',
            'Strict-Transport-Security': 'max-age=31536000'
        });

        next();
    }
];

function setYaUID(req, res, next) {
    if (!req.cookies.yandexuid) {
        var yuid = Math.floor(Math.random() * 1e8 + 1).toString() + Math.floor(new Date().getTime() / 1000).toString();
        var domain = /.*(.yandex\..*)/.exec(req.hostname);
        var options = {
            domain: (domain !== null && domain[1]) || '.yandex.ru',
            maxAge: 10 * 365 * 24 * 60 * 60 * 1000
        };

        res.cookie('yandexuid', yuid, options);
    }
    next();
}

function clearParams(req, res, next) {
    var parseUrl = urlFormat.parse(req.url);

    res.queData = {};
    url.query = {};
    url.search = parseUrl.search ? parseUrl.search : '';
    url.pathname = [parseUrl.pathname.replace(config.path, '')].join('');

    next();
}

var errorMsg = {
    InternalError: 'internal-exception',
    SessionInvalidError: 'integrity-data',
    YandexuidInvalidError: 'integrity-data',
    UserDeniedError: 'not_granted_access',
    ConsumerUnknownError: 'consumer-unknown',
    ProviderUnknownError: 'provider-unknown',
    ApplicationUnknownError: 'application-unknown',
    DisplayInvalidError: 'display-unknown',
    RetpathInvalidError: 'retpath-invalid',
    HostInvalidError: 'internal-exception',
    CommunicationFailedError: 'communication-failed',
    RateLimitExceededError: 'rate-limit',
    AuthorizationRequiredError: 'authorization-required',
    AccessTokenError: 'integrity-data',
    PkceCodeInvalidError: 'action_if_anonymous-invalid',
    PkceMethodInvalidError: 'action_if_anonymous-invalid'
};

function renderPage(req, res, data) {
    if (req.uatraits.BrowserName === 'MSIE' && req.uatraits.BrowserVersion * 1 <= 8) {
        pageData.windowHeight += 45;
    }

    res.status(data.errorCode ? data.errorCode : 200).send(yr.run(res.page, data));
}

function doRequest(req, res) {
    res.queData.user_ip = req.headers['x-real-ip'];
    res.queData.frontend_url = [req.headers['x-real-scheme'], '://', req.hostname, config.path].join('');

    var token = req.body['token'] || req.query['token'];
    var yandexToken = req.body['yandex_token'] || req.query['yandex_token'];
    var provider = req.body['provider'] || req.query['provider'];
    var experiments = req.query.experiments;

    if (token) {
        res.queData.token = encodeURIComponent(token);
    }

    if (yandexToken) {
        res.queData.token = encodeURIComponent(yandexToken);
    }

    _.forEach(['track', 'yandexuid', 'Session_id'], function(item) {
        if (req.cookies[item]) {
            res.queData[item] = req.cookies[item];
        }
    });

    _.forEach(['captcha_sid', 'captcha_answer'], function(item) {
        var param = req.body[item] || req.query[item];

        if (param) {
            res.queData[item] = encodeURIComponent(param);
        }
    });

    var app = encodeURIComponent(provider);
    var appName = '';
    var postData = querystring.stringify(res.queData);

    // елси хотим ошибку
    // url.query.raise_exception = 'AuthorizationRequiredError';

    if (experiments) {
        url.query.experiments = experiments;
    }

    res.link = urlFormat.format(url);

    console.log(
        'INFO broker request',
        '[' + new Date() + ']',
        req.headers['x-real-ip'],
        req.headers['user-agent'],
        res.link
    );

    fetch.call(res.link, res.queData).then(({err, response, data}) => {
        if (data) {
            data = JSON.parse(data);

            if (data.cookies) {
                res.setHeader('Set-Cookie', data.cookies);
            }
        }

        if (err || data.error) {
            res.page = 'error';

            if (err) {
                console.error(
                    'WARN broker error',
                    '[' + new Date() + ']',
                    req.headers['x-real-ip'],
                    req.headers['user-agent'],
                    res.link,
                    err
                );
                pageData.content = loc.error[errorMsg['InternalError']];
                pageData.errorCode = 500;
            } else if (data.error) {
                console.error(
                    'WARN broker error',
                    '[' + new Date() + ']',
                    req.headers['x-real-ip'],
                    req.headers['user-agent'],
                    res.link,
                    data
                );

                if (data.passthrough && data.retpath) {
                    console.log(
                        'INFO broker redirect',
                        '[' + new Date() + ']',
                        req.headers['x-real-ip'],
                        req.headers['user-agent'],
                        data.retpath
                    );
                    return res.redirect(data.retpath);
                }

                if (data.provider) {
                    if (!app) {
                        app = data.provider.code || data.provider;
                    }
                    appName = data.provider.name || '';
                }

                pageData.app = app;
                pageData.content = loc.error[errorMsg[data.error.code]];
                pageData.request_id = data.request_id;

                if (data.retry_url && data.error.code !== 'ProviderUnknownError') {
                    pageData.retry_url = data.retry_url;
                }

                if (data.retpath) {
                    pageData.retpath = data.retpath;
                }

                if (data.error.code === 'UserDeniedError') {
                    pageData.content = pageData.content.replace(
                        '%provider%',
                        '<b>' + (loc.common[appName] || '') + '</b>'
                    );
                }

                if (data.error.code === 'InternalError') {
                    pageData.errorCode = 500;
                }

                if (data.error.code === 'RetpathInvalidError') {
                    pageData.errorCode = 400;
                }
            }

            if (res.skipRender) {
                return res
                    .status((err && 500) || response.statusCode || 500)
                    .json((data && data.error) || defaultError);
            }
        } else {
            if (data.state && data.state === 'bind') {
                res.page = 'bind';

                if (!data.display_name.social) {
                    data.display_name.social = {
                        provider: 'ya'
                    };
                }

                pageData = _.merge(pageData, data);
                var profile = [
                    '<span class="s-profile-inline s-profile-' + data.provider.code + '">',
                    '<span class="s-profile-icon"></span>',
                    _.escape(data.profile.name || data.profile.username || data.profile.userid),
                    '</span>'
                ].join('');
                var account = [
                    '<span class="s-profile-inline s-profile-' + data.display_name.social.provider + '">',
                    '<span class="s-profile-icon"></span>',
                    _.escape(data.display_name.name),
                    '</span>'
                ].join('');

                pageData.content = loc.greet.attach_profile.replace('%profile%', profile).replace('%account%', account);
                pageData.continueButton = loc.common['button.continue'];
                delete pageData.cookies;
            }

            if (data.state && data.state === 'captcha') {
                var passportLoc = require('../i18n/passport.json')[res.locals.lang]['Frontend'];

                res.page = 'captcha';
                pageData.continueButton = loc.common['button.continue'];
                pageData.content = loc.common['captcha_label'] || '';
                pageData.captchaErrors = {
                    incorrect: passportLoc['answer_errors_incorrect'] || '',
                    missingvalue: passportLoc['answer_errors_missingvalue'] || ''
                };

                pageData = _.merge(pageData, data);
            }

            if (data.location) {
                res.redirect(data.location);
                console.log(
                    'INFO broker redirect',
                    '[' + new Date() + ']',
                    req.headers['x-real-ip'],
                    req.headers['user-agent'],
                    data.location
                );
                return;
            }
        }

        if (res.skipRender) {
            res.status(200).json(data);
            return;
        }

        renderPage(req, res, pageData);
    });
}

exports.redirect = [
    setup,
    setYaUID,
    clearParams,
    function(req, res, next) {
        url.pathname = '/redirect';
        url.query = req.query;

        next();
    },
    doRequest
];

exports.start = [
    setup,
    setYaUID,
    clearParams,
    function(req, res, next) {
        var params = [
            'application',
            'bind',
            'code_challenge',
            'code_challenge_method',
            'consumer',
            'display',
            'force_prompt',
            'login_hint',
            'passthrough_errors',
            'place',
            'provider',
            'require_auth',
            'retpath',
            'return_brief_profile',
            'scope',
            'user_param',
            'sid'
        ];

        url.pathname = '/start';

        _.forEach(params, function(item) {
            var param = req.query[item];

            if (param) {
                if (item === 'bind') {
                    url.query['require_auth'] = param;
                } else {
                    url.query[item] = param;
                }
            }
        });

        delete url.search;

        if (!req.query['resize']) {
            return next();
        }

        var result = yr.run('spin', {
            st_path: config.st_path,
            redirectTo: urlFormat.format(
                urlFormat.parse(
                    urlFormat.format({
                        protocol: 'https',
                        host: req.hostname,
                        pathname: req.path,
                        query: url.query
                    }),
                    true
                )
            ),
            app: encodeURIComponent(_.escape(url.query['provider'] || url.query['application']))
        });

        res.send(result);
    },
    doRequest
];

exports.authzInAppStart = [
    setup,
    setYaUID,
    clearParams,
    function(req, res, next) {
        url.pathname = '/authz_in_app/start';
        var params = [
            'application_name',
            'code_challenge',
            'code_challenge_method',
            'consumer',
            'display',
            'passthrough_errors',
            'place',
            'retpath',
            'user_param',
            'yandex_auth_code'
        ];

        params.forEach(function(item) {
            var param = _.escape(req.body[item] || req.query[item]);

            if (param) {
                url.query[item] = param;
            }
        });

        delete url.search;

        if (!req.query['resize']) {
            return next();
        }

        var result = yr.run('spin', {
            st_path: config.st_path,
            redirectTo: urlFormat.format({
                protocol: 'https',
                host: req.hostname,
                pathname: req.path,
                query: url.query
            }),
            app: encodeURIComponent(url.query['provider'] || url.query['application'])
        });

        res.send(result);
    },
    doRequest
];

exports.callback = [setup, clearParams, doRequest];

exports.authzInAppCallback = [setup, clearParams, doRequest];

exports.continue = [setup, clearParams, doRequest];

exports.reverse = [
    setup,
    clearParams,
    function(req, res, next) {
        url.pathname = '/tw_reverse_auth_token';
        res.skipRender = true;
        var params = ['consumer', 'application', 'provider'];

        _.forEach(params, function(item) {
            var param = _.escape(req.body[item] || req.query[item]);

            if (param) {
                url.query[item] = param;
            }
        });

        delete url.search;

        next();
    },
    doRequest
];

exports.retry = [
    setup,
    clearParams,
    function(req, res, next) {
        var params = [
            'application',
            'bind',
            'consumer',
            'display',
            'force_prompt',
            'login_hint',
            'place',
            'provider',
            'require_auth',
            'retpath',
            'return_brief_profile',
            'scope',
            'sid'
        ];

        _.forEach(params, function(item) {
            var param = _.escape(req.body[item] || req.query[item]);

            if (param) {
                if (item === 'bind') {
                    url.query['require_auth'] = param;
                } else {
                    url.query[item] = param;
                }
            }
        });

        delete url.search;

        next();
    },
    doRequest
];

exports.bind = [
    setup,
    clearParams,
    function(req, res, next) {
        res.queData = {
            allow: 1
        };

        next();
    },
    doRequest
];

exports.bindByToken = [
    setup,
    clearParams,
    function(req, res, next) {
        url.pathname = '/bind_by_token';
        var params = [
            'provider',
            'application',
            'retpath',
            'place',
            'consumer',
            'ui_language',
            'return_brief_profile',
            'scope'
        ];

        _.forEach(params, function(item) {
            var param = _.escape(req.body[item] || req.query[item]);

            if (param) {
                url.query[item] = param;
            }
        });

        ['provider_token', 'provider_token_secret'].forEach(function(item) {
            var param = _.escape(req.body[item] || req.query[item]);

            if (param) {
                res.queData[item] = param;
            }
        });

        delete url.search;

        next();
    },
    doRequest
];

exports.authzInAppEntrustToAccount = [
    setup,
    clearParams,
    function(req, res, next) {
        url.pathname = '/authz_in_app/entrust_to_account';
        res.skipRender = true;
        var params = ['task_id', 'token', 'code_verifier'];

        _.forEach(params, function(item) {
            var param = _.escape(req.body[item] || req.query[item]);

            if (param) {
                res.queData[item] = param;
            }
        });

        delete url.search;

        next();
    },
    doRequest
];
