/* istanbul ignore file */
/* eslint-disable no-unused-vars */

var config = require('../configs/current');
var yr = require('yate/lib/runtime');
var locs = require('../loc/social.json');
var getTld = require('../lib/oldUtils').getTld;
var view = require('../views/index.js');
var commonSetup = require('./commonSetup.js');
var urlFormat = require('url');

exports.route = function(app) {
    app.get(config.path + '/demo', this.index).get(config.path + '/demo_entry', this.demoEntry);
};

exports.demoEntry = function(req, res) {
    require('../views/spin.js');

    var provider = req.body['provider'] || req.query['provider'];
    var data = {
        st_path: config.st_path,
        redirectTo: urlFormat.format({
            protocol: 'https',
            host: req.hostname,
            pathname: config.path + '/start',
            query: req.query
        }),
        app: encodeURIComponent(provider)
    };

    var result = yr.run('spin', data);

    res.send(result);
};

exports.index = [
    commonSetup,
    function(req, res) {
        res.locals.lang =
            (req.langdetect && ['ru', 'en', 'uk', 'tr'].includes(req.langdetect.id) && req.langdetect.id) || 'ru';

        var loc = locs[res.locals.lang];
        var prov = [
            {app: 'fb', name: 'Facebook'},
            {app: 'tw', name: 'Twitter'},
            {app: 'vk', name: 'Vkontakte'},
            {app: 'gg', name: 'Google'},
            {app: 'mr', name: 'MailRu'},
            {app: 'ok', name: 'Odnoklassniki'},
            {app: 'ig', name: 'Instagram'},
            {app: 'lf', name: 'last.fm'},
            {app: 'lj', name: 'livejournal'}
        ];
        var displayType = req.uatraits.isMobile ? 'touch' : 'popup';
        var result = yr.run('index', {
            providers: prov,
            st_path: config.st_path,
            status: req.body['status'] || req.query['status'],
            display: displayType,
            passport: loc.common['title.passport'],
            lang: res.locals.lang,
            tld: getTld(req.hostname)
        });

        res.send(result);
    }
];
