const cssnano = require('cssnano');
const autoprefixer = require('autoprefixer');

module.exports = {
    plugins:
        process.env.NODE_ENV === 'development'
            ? []
            : [
                  autoprefixer({
                      browsers: [
                          'ff >= 19',
                          'ie >= 9',
                          'opera >= 11',
                          'safari >= 5',
                          'chrome >= 25',
                          'android >= 4',
                          'ios >= 6'
                      ]
                  }),
                  cssnano({
                      preset: [
                          'default',
                          {
                              discardComments: {
                                  removeAll: true
                              }
                          }
                      ]
                  })
              ]
};
