const util = require('util');
const he = require('he');
const config = require('../../configs/current');
const locs = require('../../loc/social.json');
const commonSetup = require('../../lib/commonSetup');
const client = require('../../lib/client');
const generalError = require('./common/generalError');
const apiResponseError = require('./common/apiResponseError');
const csrf = require('csurf');
const newBrokerExpFilter = require('../../lib/newBrokerExpFilter');
const renderPage = require('../../dist/index.server').renderPage;
const csrfProtection = csrf({
    cookie: {
        httpOnly: true,
        secure: true
    }
});

exports.route = (app) => app.get(`${config.path}/authz_in_web/:task_id/bind`, newBrokerExpFilter, bind);

const bind = [
    commonSetup,
    csrfProtection,
    (req, res, next) =>
        doRequest(req, res)
            .then(({body}) => {
                const {language} = res.locals;
                const {
                    account_display_name,
                    application_display_name,
                    cancel_url: cancelUrl,
                    cookies,
                    location,
                    status
                } = body;

                if (cookies) {
                    res.append('Set-Cookie', cookies);
                }

                if (status === 'redirect' && location) {
                    return res.redirect(location);
                }

                if (status === 'form_bind_agreement') {
                    const loc = locs[language];
                    const description = util.format(
                        loc.common['authz_in_web_need_confirm_content'],
                        `<strong>${he.escape(account_display_name.name)}</strong>`,
                        `<strong>${he.escape(application_display_name)}</strong>`
                    );

                    res.status(200);
                    res.location.store.app = {
                        screen: 'formBind',
                        title: loc.common['authz_in_web_need_confirm_title'],
                        description,
                        csrfToken: req.csrfToken(),
                        cancelUrl
                    };

                    renderPage(req, res);
                }
            })
            .catch(next),
    apiResponseError,
    generalError
];

const doRequest = (req) => {
    const {
        params: {task_id},
        query,
        headers: {'x-real-ip': user_ip},
        cookies: {Session_id, track}
    } = req;

    return client.call('/authz_in_web/bind/submit', {
        method: 'POST',
        form: true,
        query,
        body: {
            task_id,
            track,
            Session_id,
            user_ip
        }
    });
};
