const he = require('he');
const util = require('util');
const url = require('url');
const config = require('../../configs/current');
const locs = require('../../loc/social.json');
const commonSetup = require('../../lib/commonSetup');
const client = require('../../lib/client');
const apiResponseError = require('./common/apiResponseError');
const generalError = require('./common/generalError');
const newBrokerExpFilter = require('../../lib/newBrokerExpFilter');
const renderPage = require('../../dist/index.server').renderPage;

exports.route = (app) => {
    // app.use(config.path + '/authz_in_web', newBrokerExpFilter, pino);
    app.get(`${config.path}/authz_in_web/:task_id/callback`, newBrokerExpFilter, callback);
};

const callback = [
    commonSetup,
    (req, res, next) => {
        return doRequest(req, res)
            .then(({body}) => {
                const {application_display_name, cancel_url, retry_url, cookies, location, status} = body;

                if (cookies) {
                    res.append('Set-Cookie', cookies);
                }

                if (status === 'redirect' && location) {
                    return res.redirect(location);
                }

                if (status === 'form_try_again') {
                    const {language} = res.locals;
                    const loc = locs[language];
                    const description = util.format(
                        loc.common['authz_in_web_ensure_content'],
                        `<strong>${he.escape(application_display_name)}</strong>`
                    );

                    res.status(200);
                    res.location.store.app = {
                        process: 'authzInWeb',
                        screen: 'error',
                        title: loc.common['authz_in_web_ensure_title'],
                        description,
                        retpath: cancel_url,
                        retry_url
                    };

                    renderPage(req, res);
                }
            })
            .catch(next);
    },
    apiResponseError,
    generalError
];

const doRequest = (req) => {
    const {
        params: {task_id},
        originalUrl,
        headers: {'x-real-ip': user_ip},
        cookies: {Session_id, track}
    } = req;

    return client.call('/authz_in_web/callback', {
        method: 'POST',
        form: true,
        body: {
            query: url.parse(originalUrl).search.slice(1),
            task_id,
            track,
            Session_id,
            user_ip
        }
    });
};
