const config = require('../../configs/current');
const commonSetup = require('../../lib/commonSetup');
const client = require('../../lib/client');
const generalError = require('./common/generalError');
const apiResponseError = require('./common/apiResponseError');
const newBrokerExpFilter = require('../../lib/newBrokerExpFilter');
const csrf = require('csurf');
const csrfProtection =
    process.env.RUNNER === 'jest'
        ? (req, res, next) => next()
        : csrf({
              cookie: true
          });

exports.route = (app) => {
    app.get(`${config.path}/authz_in_web/:task_id/collect_diagnostics`, newBrokerExpFilter, collectDiagnostics);
};

const collectDiagnostics = [
    commonSetup,
    csrfProtection,
    (req, res, next) => {
        return doRequest(req, res)
            .then(({body: {status, location}}) => {
                if (status === 'redirect' && location) {
                    return res.redirect(location);
                }

                return next();
            })
            .catch(next);
    },
    apiResponseError,
    generalError
];

function doRequest(req) {
    const {
        params: {task_id},
        query,
        headers: {'x-real-ip': user_ip},
        cookies: {Session_id, track}
    } = req;

    return client.call('/authz_in_web/collect_diagnostics', {
        method: 'POST',
        form: true,
        query,
        body: {
            task_id,
            track,
            Session_id,
            user_ip
        }
    });
}
