/* istanbul ignore file */

const getPageContentByErrorCode = require('./getPageContentByErrorCode.js');
const locs = require('../../../loc/social.json');
const renderPage = require('../../../dist/index.server').renderPage;

module.exports = (error, req, res, next) => {
    const {language} = res.locals;
    const loc = locs[language];

    if (error.name !== 'HTTPError') {
        return next(error);
    }

    const {
        body: {
            error: {code},
            retpath,
            request_id
        },
        statusCode
    } = error;

    res.status(statusCode || 200);
    res.locals.store.app = {
        screen: 'error',
        description: getPageContentByErrorCode(code, language),
        title: loc.common['errror.title'],
        retpath,
        request_id,
        noForceClose: true
    };

    renderPage(req, res);
};
