/* istanbul ignore file */

const getPageContentByErrorCode = require('./getPageContentByErrorCode.js');
const locs = require('../../../loc/social.json');
const renderPage = require('../../../dist/index.server').renderPage;

// eslint-disable-next-line no-unused-vars
module.exports = (error, req, res, next) => {
    const {language} = res.locals;
    const loc = locs[language];

    let statusCode = 500;

    let message = error.message;

    if (error.name === 'JsonSchemaValidationError') {
        message = 'missed required query parameter';
        statusCode = 400;
    }

    if (error.name === 'ForbiddenError') {
        statusCode = 403;
    }

    res.status(statusCode);
    res.locals.store.app = {
        screen: 'error',
        description: getPageContentByErrorCode(error.code, language),
        title: loc.common['errror.title'],
        request_id: `${message && message.split(' ').join('-')}-${new Date().getTime()}`,
        noForceClose: true
    };

    renderPage(req, res);
};
