const config = require('../../configs/current');
const {Validator} = require('express-json-validator-middleware');
const commonSetup = require('../../lib/commonSetup');
const schema = require('../schema.json');
const client = require('../../lib/client');
const generalError = require('./common/generalError');
const apiResponseError = require('./common/apiResponseError');
const newBrokerExpFilter = require('../../lib/newBrokerExpFilter');
const validator = new Validator({allErrors: true});
const {validate} = validator;

exports.route = (app) => app.get(`${config.path}/authz_in_web/start`, newBrokerExpFilter, start);

const start = [
    commonSetup,
    validate({query: schema}),
    (req, res, next) => {
        return doRequest(req, res)
            .then(({body: {status, location, cookies}}) => {
                if (cookies) {
                    res.append('Set-Cookie', cookies);
                }

                if (status === 'redirect' && location) {
                    return res.redirect(location);
                }
            })
            .catch(next);
    },
    apiResponseError,
    generalError
];

const doRequest = (req) => {
    const {
        query: {application_name, consumer, retpath, flags, user_param},
        headers: {'x-real-ip': user_ip},
        cookies: {Session_id}
    } = req;

    return client.call('authz_in_web/start', {
        method: 'POST',
        form: true,
        body: {
            application_name,
            consumer,
            retpath,
            flags,
            Session_id,
            user_ip,
            user_param
        }
    });
};
