/* istanbul ignore file */

const url = require('url');
const config = require('../configs/current');
const commonSetup = require('../lib/commonSetup');
const newBrokerExpFilter = require('../lib/newBrokerExpFilter');
const renderPage = require('../dist/index.server').renderPage;

exports.route = (app) =>
    app
        .get(`${config.path}/demo`, newBrokerExpFilter, indexEntry)
        .get(`${config.path}/demo_entry`, newBrokerExpFilter, demoEntry);

const demoEntry = [
    commonSetup,
    (req, res, next) => {
        const {store} = res.locals;
        const provider = req.body['provider'] || req.query['provider'];

        store.app = {
            location: url.format({
                protocol: 'https',
                host: req.hostname,
                pathname: `${config.path}/start`,
                query: req.query
            }),
            app: encodeURIComponent(provider),
            screen: 'redirector'
        };

        next();
    },
    renderPage
];

const indexEntry = [
    commonSetup,
    (req, res, next) => {
        const {store} = res.locals;

        store.app = {
            providers: [
                {app: 'fb', name: 'Facebook'},
                {app: 'tw', name: 'Twitter'},
                {app: 'vk', name: 'Vkontakte'},
                {app: 'gg', name: 'Google'},
                {app: 'mr', name: 'MailRu'},
                {app: 'ok', name: 'Odnoklassniki'},
                {app: 'ig', name: 'Instagram'},
                {app: 'lf', name: 'last.fm'},
                {app: 'lj', name: 'livejournal'},
                {app: 'sberbank', name: 'Sberbank'}
            ],
            status: req.body['status'] || req.query['status'],
            screen: 'demo'
        };

        next();
    },
    renderPage
];
