import React from 'react';
import {Provider} from 'react-redux';
import {hydrate} from 'react-dom';
import {configureStore} from '@lib/configureStore';
import {App} from '@blocks/App';

(() => {
    const body = document.querySelector('body');
    const store = configureStore(JSON.parse(body.dataset.store));

    delete body.dataset.store;

    hydrate(
        <Provider store={store}>
            <App />
        </Provider>,
        document.getElementById('app')
    );
})();
