import React from 'react';
import {renderToNodeStream} from 'react-dom/server';
import {Provider} from 'react-redux';
import {Template} from '@lib/Template';
import {configureStore} from '@lib/configureStore';
import {App} from '@blocks/App';

const renderPage = (req, res) => {
    const {store = {}} = res.locals;
    const {settings = {}} = store;
    const {staticPath, title, uatraits = {}} = settings;
    const {isTouch} = uatraits;
    const templateProps = {
        staticPath,
        title,
        store,
        isTouch
    };

    res.type('html');
    renderToNodeStream(
        <Template {...templateProps}>
            <Provider store={configureStore(store)}>
                <App />
            </Provider>
        </Template>
    ).pipe(res);
};

export {renderPage};
