/**
 * Initially authored by aandrosov@
 * @example node ./build.js output file1.styl file2.styl file3.styl
 */

var PATH = require('path');
var FS = require('fs');

var out = process.argv[2];
var outDir = PATH.dirname(out);

compile(
    out,
    process.argv
        .slice(3)
        .map(function(name) {
            return '@import "' + PATH.relative(outDir, name) + '"';
        })
        .join('\n')
);

function compile(path, str) {
    var stylus = require('stylus');
    var utilusPath = PATH.resolve(outDir, __dirname + '/../node_modules/utilus.styl');
    var ifIePath = PATH.resolve(outDir, __dirname + '/../node_modules/if-ie.styl');

    var handleError = function(err) {
        if (err) {
            console.error('** ERROR');
            console.error(err.name);
            console.error(err.message);
            console.error(err.filename + '@' + err.lineno);
            process.exit(1);
        }
    };

    var write = function(path, css) {
        // не пишем в stdout,
        // чтобы в случае ошибки не получить пустой файл
        console.log('Writing css for', path);
        FS.writeFileSync(path, css, 'utf-8');
    };

    var postcss = require('postcss');
    var autoprefixer = require('autoprefixer');

    var render = function(ie, browsers) {
        stylus(str)
            .set('filename', path)
            .set('resolve url', true)
            .set('paths', [__dirname, utilusPath, ifIePath])
            .define('url', stylus.resolver())
            .define('ie', ie)
            .render(function(err, css) {
                handleError(err);

                var prefixedCSS = postcss([autoprefixer({browsers: browsers})]).process(css);

                if (ie) {
                    path += '.ie';
                }

                write(path + '.css', prefixedCSS);
            });
    };

    // For normal browsers
    render(false, ['ff >= 19', 'ie >= 9', 'opera >= 11', 'safari >= 5', 'chrome >= 25', 'android >= 4', 'ios >= 6']);

    // For IE
    render(true, ['ie 8', 'ie 7']);
}
