const nodeExternals = require('webpack-node-externals');
const MiniCssExtractPlugin = require('mini-css-extract-plugin');
const OptimizeCSSAssetsPlugin = require('optimize-css-assets-webpack-plugin');
const TerserJSPlugin = require('terser-webpack-plugin');
const path = require('path');

const client = {
    entry: [path.resolve(__dirname, './src/index.client.js')],
    output: {
        path: path.resolve(__dirname, './dist'),
        publicPath: '/dist/',
        filename: 'index.client.js'
    },
    resolve: {
        extensions: ['.js', '.jsx'],
        modules: ['node_modules'],
        alias: {
            '@components': path.resolve(__dirname, 'blocks/Components'),
            '@blocks': path.resolve(__dirname, 'blocks'),
            '@lib': path.resolve(__dirname, 'lib')
        }
    },
    module: {
        rules: [
            {
                test: /\.jsx?$/,
                loader: 'babel-loader',
                exclude: /node_modules/
            },
            {
                test: /\.styl$/,
                use: [
                    MiniCssExtractPlugin.loader,
                    {
                        loader: 'css-loader',
                        options: {
                            url: false
                        }
                    },
                    'postcss-loader',
                    'stylus-loader'
                ]
            },
            {
                test: /\.css$/,
                include: /node_modules/,
                use: [MiniCssExtractPlugin.loader, 'css-loader', 'postcss-loader']
            },
            {
                test: /\.(jpe?g|png|ttf|gif|eot|svg|woff(2)?)(\?[a-z0-9=&.]+)?$/,
                include: /node_modules/,
                use: 'base64-inline-loader'
            }
        ]
    },
    plugins: [
        new MiniCssExtractPlugin({
            filename: 'index.css'
        }),
        new TerserJSPlugin({
            parallel: false,
            extractComments: false
        }),
        new OptimizeCSSAssetsPlugin({})
    ]
};

const server = {
    target: 'node',
    externals: [nodeExternals()],
    entry: path.resolve(__dirname, './src/index.server.js'),
    output: {
        path: path.resolve(__dirname, './dist'),
        publicPath: '/dist/',
        filename: 'index.server.js',
        libraryTarget: 'commonjs2'
    },
    resolve: {
        extensions: ['.js', '.jsx'],
        alias: {
            '@components': path.resolve(__dirname, 'blocks/Components'),
            '@blocks': path.resolve(__dirname, 'blocks'),
            '@lib': path.resolve(__dirname, 'lib')
        }
    },
    module: {
        rules: [
            {
                test: /\.jsx?$/,
                loader: 'babel-loader',
                exclude: /node_modules/
            },
            {
                test: /\.styl$/,
                loader: 'null-loader'
            },
            {
                test: /\.(ttf|eot|otf|svg|png)$/,
                loader: 'null-loader'
            },
            {
                test: /\.(woff|woff2)$/,
                loader: 'null-loader'
            }
        ]
    }
};

module.exports = [client, server];
