const inherit = require('inherit');
const Disk = require('papi/Disk');
const HttpDAO = require('pdao/Http');

const config = require('../../config/current');
const retryCondition = require('papi/Disk/retryCondition');

const daoConfig = config.api.disk.dao;

module.exports = inherit(Disk, {
    __constructor: function (logID) {
        const dao = new HttpDAO(
            logID,
            daoConfig.baseUrl,
            daoConfig.maxRetries,
            daoConfig.retryAfter,
            daoConfig.maxConnections,
            daoConfig.timeout,
            retryCondition()
        );

        this.__base(logID, dao);
    }
});
