const inherit = require('inherit');
const OAuth = require('papi/OAuth');
const HttpDAO = require('pdao/Http');

const config = require('../../config/current');
const retryCondition = require('papi/OAuth/retryCondition');

const daoConfig = config.api.oauth.dao;

module.exports = inherit(OAuth, {
    __constructor: function (logID, rawHeaders, lang, uid) {
        const dao = new HttpDAO(
            logID,
            daoConfig.baseUrl,
            daoConfig.maxRetries,
            daoConfig.retryAfter,
            daoConfig.maxConnections,
            daoConfig.timeout,
            retryCondition(daoConfig.retryCodes)
        );

        this.__base(logID, dao, 'oauth_frontend', rawHeaders, lang, uid);
    }
});
