const inherit = require('inherit');
const Passport = require('papi/Passport');
const HttpDAO = require('pdao/Http');

const config = require('../../config/current');
const retryCondition = require('papi/Passport/retryCondition');

const daoConfig = config.api.passport.dao;

module.exports = inherit(Passport, {
    __constructor: function (logID, headers, lang) {
        const dao = new HttpDAO(
            logID,
            daoConfig.baseUrl,
            daoConfig.maxRetries,
            daoConfig.retryAfter,
            daoConfig.maxConnections,
            daoConfig.timeout,
            retryCondition(daoConfig.retryCodes)
        );

        this.__base(logID, dao, headers, 'oauth_frontend', lang);
    }
});
