/* eslint-env node */

module.exports = (api) => {
    // api.cache(true);
    const web = api.caller(isWebTarget);
    const webpack = api.caller(isWebpack);
    const presets = [
        '@babel/preset-react',
        [
            '@babel/preset-env',
            {
                targets: !web ? {node: 'current'} : undefined,
                useBuiltIns: web ? 'entry' : undefined,
                corejs: web ? 'core-js@3' : false,
                modules: webpack ? false : 'commonjs'
            }
        ]
    ];
    const plugins = [
        'jsx-control-statements',
        '@babel/plugin-syntax-dynamic-import',
        '@babel/plugin-proposal-class-properties',
        '@loadable/babel-plugin'
    ];

    return {
        presets,
        plugins
    };
};

function isWebTarget(caller) {
    return Boolean(caller && caller.target === 'clientside');
}

function isWebpack(caller) {
    return Boolean(caller && caller.name === 'babel-loader' && caller.target === 'clientside');
}
