/* global uid */
/* global login */
/* global passportHost */
/* see layout.yate */
(function(uid, initialLogin, passportHost) {
    if (!uid) {
        //'No uid known. Is user logged in?'
        return;
    }

    var yloginMatcher = /yandex_login=[^;]+/;
    var getYLoginCookie = function() {
        var ylogin = document.cookie.match(yloginMatcher);
        ylogin = (ylogin && ylogin[0]) || '';
        return ylogin.replace('yandex_login=', '');
    };

    var yuidMatcher = /yandexuid=[^;]+/;
    var getYUidCookie = function() {
        var yuid = document.cookie.match(yuidMatcher);
        yuid = (yuid && yuid[0]) || '';
        return yuid.replace('yandexuid=', '');
    };

    if (!initialLogin) {
        //No initial login known, using a cookie — may be affected by race conditions.
        initialLogin = getYLoginCookie();
    }

    var changeDefault = function() {
        var tld = location.host.match(/\.[a-z]+$/);
        tld = {                    //Authenticate at the root domain in an area
            '.tr': '.com.tr',      //.com.tr for Turkey
            '.com': '.com'         //.com for .com
        }[tld && tld[0]] || '.ru'; //.ru for everyone else

        var url = 'https://' + passportHost + '/passport?mode=embeddedauth&action=change_default';
        url += '&retpath=https%3A%2F%2Fyandex' + tld + '%2Ffavicon.ico';
        url += '&uid=' + uid;
        url += '&yu=' + getYUidCookie();

        var iframe = document.createElement('iframe');
        iframe.src = url;
        iframe.className = 'g-hidden';
        iframe.setAttribute("style", "display: none;");
        document.body.appendChild(iframe);

        var iframeRemoved = false;
        var removeIframe = function() {
            if (!iframeRemoved) {
                document.body.removeChild(iframe);
                iframeRemoved = true;
            }
        };

        iframe.onload = removeIframe; //Remove onload or
        window.setTimeout(removeIframe, 60 * 1000); //Remove after a timeout
    };

    var timer;
    var onVisible = function() {
        window.clearTimeout(timer);
        timer = window.setTimeout(function() {
            if (getYLoginCookie() !== initialLogin) {
                changeDefault();
            }
        }, 10); //Debounce
    };

    /**
     Visibility detection courtesy of yandex.mail: https://github.yandex-team.ru/Daria/www/blob/46234bdbfa221375e3fd7e2704ef0697b0031d1d/js/daria.page.visibility.js

     Определяет видимость страницы через Visibility API или обычными способами.
     @see http://www.w3.org/TR/page-visibility/
     @see http://www.nczonline.net/blog/2011/08/09/introduction-to-the-page-visibility-api/
     @see https://developer.mozilla.org/en/DOM/Using_the_Page_Visibility_API
     */
    if ('hidden' in document || 'msHidden' in document || 'mozHidden' in document || 'webkitHidden' in document) {
        var isPageVisible = function() {
            if (!(document.hidden || document.msHidden || document.mozHidden || document.webkitHidden)) {
                onVisible();
            }
        };

        isPageVisible();

        document.addEventListener('visibilitychange', isPageVisible, false);
        document.addEventListener('msvisibilitychange', isPageVisible, false);
        document.addEventListener('mozvisibilitychange', isPageVisible, false);
        document.addEventListener('webkitvisibilitychange', isPageVisible, false);
    } else {
        var isIe = /(MSIE|Trident.*rv:11\.)/.test(window.navigator.userAgent);
        var isWebkit = 'WebkitAppearance' in document.documentElement.style;

        // https://developer.mozilla.org/en/DOM/document.hasFocus
        // http://msdn.microsoft.com/en-us/library/ms536447(v=vs.85).aspx
        // Нельзя использовать в Chrome:
        //   http://code.google.com/p/chromium/issues/detail?id=64846
        //   https://bugs.webkit.org/show_bug.cgi?id=65220
        var hasFocusSupport = !isWebkit && 'hasFocus' in document; //TODO: does it needs better webkit version detection? (newer webkits have page visibility api)

        var handleEvent = function(e) {
            var inFocus = null;
            if (hasFocusSupport) {
                // Fx3.5 кидает exception
                try {
                    inFocus = document.hasFocus();
                } catch(err) {}
            }
            if (inFocus === null) {
                inFocus = !e || e.type === 'focus' || e.type === 'focusin';
            }

            if (inFocus) {
                onVisible();
            }
        };

        handleEvent();

        // Tab focus and blur events
        if (isIe) {
            // attachEvent is supported in IE up to version 11,
            // but pagevisibility works from version 10, so we won't be there
            document.attachEvent('focusin', handleEvent);
        } else {
            window.addEventListener('focus', handleEvent);
        }
    }
})(uid, login, passportHost);
