passport.pin = (function() {
    var api = passport.api;
    var originalRequest = api.request;

    return function(uid) {
        if (!uid) {
            //No uid to pin
            return;
        }

        //Hack api requests to have uid
        api.request = function(method, params, options) {
            params = $.extend({}, params, {uid: uid});
            return originalRequest.call(api, method, params, options);
        };

        //f5
        if (window.history && typeof window.history.replaceState === 'function') {
            var href = location.href;
            if (!/(\?|&)uid=/.test(location.search)) {
                var query = '';
                query += location.search ? '&' : '?';
                query += 'uid=' + uid;

                if (location.hash) {
                    href = href.replace(location.hash, query + location.hash);
                } else {
                    href += query;
                }
            } else {
                var search = location.search;
                search = search.replace(/uid=\d*/, 'uid=' + uid);
                href = href.replace(location.search, search);
            }

            window.history.replaceState(null, document.title, href);
        }
    };
})();

/* global uid */
/* see layout.yate */
passport.pin(uid);
