var YateManualException = require('inherit')(Error, {
    name: 'YateManualException',
    __constructor: function(message) {
        this.message = message;
        Error.captureStackTrace(this, YateManualException);
    }
});

module.exports = function(yr) {
    var logger = new (require('plog'))(null, 'oauth', 'yate', 'externals');

    //Подгрузка экстерналов наноостровов
    require('vm').runInNewContext(require('fs').readFileSync('./plibs/nanoislands/externals.yate.js', 'utf-8'), {yr: yr});

    //Экстерналы для хэдера
    require('pheader/header.yate.externals.js')(yr);

    yr.externals['i18n'] = function(lang, locKey) {
        /* jshint unused:false */
        logger.verbose().type('i18n').write('Localizing %s for lang %s', Array.prototype.slice.call(arguments, 1), lang);

        var i18n = require('putils').i18n;
        return i18n.apply(i18n, arguments);
    };

    /**
     * i18n that outputs xml
     * XSS warning!
     *
     * Use with format below
     * @example
     *  //key: 'hello, %1'
     *  concatMe = (
     *      beginning <a href="yandex.ru">%s</a>, end
     *  )
     *
     *  userInput = '<script>alert("evil")</script>'
     *  i18n-xml('ru', 'key', format(concatMe, userInput))
     *  //Outputs "hello, <a href="yandex.ru">&lt;script&gt;
     */
    yr.externals['i18n-xml'] = yr.externals['i18n'];

    /**
     * Format the xml with escaped values
     * Values are escaped by yate when converting from scalar to xml
     *
     * @param {string} format
     * @param {string...} values
     * @returns {string}
     */
    yr.externals['format'] = function(format, values) {
        /* jshint unused:false */

        var args = Array.prototype.slice.call(arguments, 1);
        logger.verbose().type('i18n').write('Formatting %s with %s', format, args);

        var util = require('util');
        return util.format.apply(util, arguments);
    };

    yr.externals['wrap'] = yr.externals['_nb-wrap']; //Shameless steal
    yr.externals['extend'] = yr.externals['_nb-extend']; //Shameless steal

    /**
     * Конвертация yate-объекта в строку
     * @param {Object} obj
     * @returns {string}
     */
    yr.externals['stringify'] = function(obj) {
        if (obj.length && obj.length > 0) {
            obj = obj[0];
        }

        if (!obj.data) {
            return null;
        }

        return JSON.stringify(obj.data);
    };

    /**
     * Spell month (1-12) with words
     *
     * @param {string} lang     two-letter lang code
     * @param {number} month    month number (1-12)
     * @returns {string}
     */
    yr.externals['spellMonth'] = function(lang, month) {
        if (typeof month !== 'number') {
            month = parseInt(month, 10);
        }

        require('assert')(month > 0 && month <= 12, 'Month should be month number');
        return require('putils').i18n(lang, 'time.month.' + (month - 1)); //Tanker months are 0 to 11
    };

    /**
     * Spell js month (0-11) in genetive case
     * @example января, февраля
     *
     * @param {string} lang     two-letter lang code
     * @param {number} month    month number in js Date format (0-11)
     * @returns {string}
     */
    yr.externals['spellMonthGen'] = function(lang, month) {
        if (typeof month !== 'number') {
            month = parseInt(month, 10);
        }

        require('assert')(month > 0 && month <= 12, 'Month should be month number');
        return require('putils').i18n(lang, 'time.month.gen.' + (month - 1)); //Tanker months are 0 to 11
    };

    yr.externals['assert'] = function(value, message) {
        require('assert')(value, message);
    };
    yr.externals['throw'] = function(message) {
        throw new YateManualException(message);
    };

    yr.externals['firstletter'] = function(str) {
        return str.slice(0, str.charCodeAt(0) > 255 ? 2 : 1);
    };

    yr.externals['allbutfirstletter'] = function(str) {
        return str.slice(str.charCodeAt(0) > 255 ? 2 : 1);
    };
};
