/**
 * @extends View
 */
module.exports = require('inherit')(require('pview'), {
    name: 'clientList',

    /**
     * @param {ClientModel[]} clientList
     * @constructor
     */
    __constructor: function(clientList) {
        this.__base.apply(this, arguments);
        require('assert')(clientList instanceof Array, 'clientList should be an instance of array');

        this._clients = require('lodash')(clientList)
            .sortBy(function(client) {
                return -client.getCreationTime();
            })
            .map(function(client) {
                return new (require('./ClientView'))(client);
            })
            .valueOf();
    },

    _compile: function() {
        return require('when')
            .all(this._clients.map(function(client) {
                return client.compile();
            }))
            .then(function(clients) {
                return { clientList: clients };
            });
    }

});
