/**
 * @extends View
 */
module.exports = require('inherit')(require('pview'), {
    name: 'clientView',

    __constructor: function(client) {
        require('assert')(client instanceof require('papi/OAuth/models/Client'), 'Client should be an instance of ClientModel');
        this.__base.apply(this, arguments);
        this._client = client;
    },

    _compile: function() {
        var client = this._client;
        var ScopesList = require('../clientScopesList/clientScopesView');
        return new ScopesList(client.getScopes())
            .compile().then(function(scopes) {
                return {
                    id: client.getId(),
                    name: client.getTitle(),
                    approval_status: client.getApprovalStatus(),
                    blocked: client.isBlocked(),
                    scopes: scopes.clientScopesList,
                    icon: client.getIcon(),
                    isYandex: client.isYandex()
                };
            });
    }
});
