const assert = require('assert');
const _ = require('lodash');
const ScopesCollection = require('papi/OAuth/models/ScopesCollection');

var transformScope = function(scope) {
    return {
        id: scope.getId(),
        title: scope.getTitle(),
        optional: scope.getOptional(),
        alreadyGranted: scope.getAlreadyGranted()
    };
};

var sortScopes = function(transformedScopes) {
    return _.sortBy(_.sortBy(
        transformedScopes,
        'id'
    ),'alreadyGranted').reverse();
};

module.exports = require('inherit')(require('pview'), {
    name: 'clientScopesList',
    __constructor: function(scopes) {
        assert(scopes instanceof ScopesCollection, 'Scopes should be an instance of ScopesCollection');
        this.__base.apply(this, arguments);
        this._scopes = scopes;
    },

    _compile: function() {
        if (this._scopes.length < 4) {
            this._logger.verbose('No section grouping');
            return {
                clientScopesList: {
                    bySection: false,
                    scopes: sortScopes(this._scopes.map(transformScope))
                }
            };
        }

        this._logger.verbose('With section grouping');
        return {
            clientScopesList: {
                bySection: true,
                scopes: _.map(this._scopes.groupBy(function(scope) {
                    return scope.getSectionTitle();
                }), function(scopes, section) {
                    return {
                        section: section,
                        values: sortScopes(_.map(scopes, transformScope))
                    };
                })
            }
        };
    }
});
