const inherit = require('inherit');
const Field = require('pform/Field');
const assert = require('assert');
const PController = require('pcontroller');

module.exports = inherit(Field, {
    __constructor: function (controller) {
        assert(controller instanceof PController, 'Controller instance expected');

        this._init('csrf').setHidden().setRequired();

        this._controller = controller;
    },

    isEmpty: function (formData) {
        return !this._parseValue(formData);
    },

    validate: async function (formData) {
        const csrf = this._parseValue(formData);

        let isValid;

        try {
            isValid = await this._controller.isCsrfTokenValidV2(csrf);
        } catch {
            isValid = false;
        }

        return isValid ? [] : ['missingvalue'];
    },

    onEmpty: function () {},
    onValid: function () {},
    onInvalid: function () {},

    compile: function () {
        var that = this;
        var base = this.__base;
        var args = arguments;

        return this._controller.getCsrfToken().then(function (token) {
            that.setValue(token);
            return base.apply(that, args);
        });
    }
});
