var _ = require('lodash');
var assert = require('assert');

/**
 * @extends Field
 */

module.exports = require('inherit')(require('pform/Field'), {
    __constructor: function() {
        this._init('icon')
            .addError(new this.__self.Error('badformat', 'field.icon.error.badformat'))
            .addError(new this.__self.Error('toolarge', 'field.icon.error.toolarge'))
            .addError(new this.__self.Error('missingvalue', 'field._common_.error.missingvalue'))
            .addError(new this.__self.Error('required', 'field._common_.error.missingvalue'));

        this._values.value = {
            file: '',
            id: '',
            delete: false
        };
    },

    _parseValue: function(formData) {
        return {
            file: formData[this.getName() + '_file'],
            id: formData[this.getName() + '_id'],
            delete: formData[this.getName() + '_delete'] === 'on'
        };
    },

    getValue: function(type) {
        return this._values.value[type];
    },

    setValue: function(value) {
        this._values.value = value || {};
        return this;
    },

    isPresent: function(formData) {
        assert(_.isPlainObject(formData), 'Argument should be a posted form data');
        return this.getName() + '_id' in formData || this.getName() + '_file' in formData;
    }
});
