(function() {
    passport.block('icon', 'control', {
        isRequired: false,
        needServerValidation: false,

        events: {
            'toggle.yandexAppFlag': 'toggleRequiredProperty',
            'change .js-icon-delete': 'toggleControlState'
        },

        validate: function(suppressError) {
            var val = this.val() || this.$('#icon_id').val();

            if (!this.isRequired) {
                this.validationResult(true, null, false);
                return;
            }

            if (!val) {
                this.validationResult(false, 'missingvalue', suppressError);
                return;
            }

            this.validationResult(true, null, false);
            return;
        },

        toggleRequiredProperty: function(event, isChecked) {
            this.isRequired = isChecked;
        },

        toggleControlState: function() {
            this.$ctrl.attr('disabled', this.$('.js-icon-delete input').is(':checked'));
        },

        checkYandexAppFlagState: function() {
            this.toggleRequiredProperty(null, passport.block('yandexAppFlag').val());
        },

        init: function() {
            this.checkYandexAppFlagState();
        }
    });
})();
