(function() {

    passport.block('submit', 'control', {
        needsServerValidation: false,
        events: {
            'click button': 'check'
        },

        isEmpty: function() {
            return false;
        },

        val: $.noop,

        /**
         * Array of control id's to check.
         * If set, only these controls would be checked.
         * All controls would be checked otherwise.
         *
         * @type string[]
         */
        controlsToCheck: null,

        check: function(event) {
            //Do not send the form implicitly
            event.preventDefault();

            //Make sure the controls are inited
            //in case we're checking all existent controls, all controls are available,
            //but only those used in a page are inited
            var controls = $.map(this.getAffectedControls(), function(control) {
                if (control.inited.already) {
                    return control;
                }

                return null;
            });

            //Revalidate all the controls, that can be validated
            var validations = $.map(controls, function(control) {
                if (typeof control.validate === 'function') {
                    return control.validate(true);
                }

                return null;
            });

            var that = this;
            $.when.apply(null, validations).always(function() {
                //When the controls are validated, check if any are invalid
                var invalidControl;
                var anyInvalid = controls.some(function(control) {
                    if (passport.validator.check(control) === false) {
                        invalidControl = control;
                        return true;
                    }
                });

                if (anyInvalid) {
                    that.onInvalid(event, invalidControl);
                } else {
                    that.onValid(event);
                }
            });
        },

        /**
         * Determine affected controls, specific or all
         * @returns {Control[]}
         */
        getAffectedControls: function() {
            return !$.isArray(this.controlsToCheck) ?
                $.map(passport.blocks, function(block) {
                    if (block.isControl && block.inited.already) {
                        return block;
                    }

                    return null;
                }) :
                $.map(this.controlsToCheck, function(blockName) {
                    return passport.block(blockName);
                });
        },

        onValid: function() {
            this.onSubmit();

            this.nbctrl.disable();

            //Send the form explicitly
            this.$el.closest('form').submit();
        },

        onInvalid: function(event, control) {
            /* jshint unused: false */
            this.nbctrl.blur(); //Remove the focus from the button, PASSP-9446 — Страница  самостоятельно скролится вниз, если заполнить обязательные поля
            this.getAffectedControls().forEach(function(control) {
                if (typeof control.validate === 'function') {
                    control.validate();
                }
            });
        },

        onSubmit: function() {/* jshint unused:false */}
    });

})();
