(function() {
    passport.block('callback', 'url', {
        isRequired: false,
        needsServerValidation: false,

        events: {
            'click .js-callback-extras-dev': 'setDevUrl'
        },

        _getLocation: function() {
            return window.location.href;
        },

        _isForbidden: function() {
            /*jshint scripturl:true*/
            return this._parseUrl(this.val()).protocol === 'javascript:';
        },

        validateSync: function() {
            if (this._isForbidden()) {
                return 'scheme_forbidden';
            }

            return null;
        },

        setDevUrl: function() {
            var a = document.createElement('a');
            a.href = this._getLocation();
            a.pathname = 'verification_code';

            this.val(a.href);
        }
    });
})();
