/**
 * @extends Field
 * @typedef URLField
 * @class URLField
 */
module.exports = require('inherit')(require('pform/Field'), {
    __constructor: function(id) {
        require('assert')(id && typeof id === 'string', 'Url field id should be a string');

        this._init(id)
            .addError(new this.__self.Error('invalid', 'field.url.error.invalid'))
            .addError(new this.__self.Error('toolong', 'field._common_.error.url_too_long'));
    }
});
