(function() {
    var url = passport.block('url', 'control', {
        updateTimeout: 0,
        needsServerValidation: false,
        canLinkToOauth: false,

        _parseUrl: function(string) {
            var url = document.createElement('a');
            url.href = string;
            return url;
        },

        _isAllowedOauthPathname: function(pathname) {
            pathname = pathname.replace(/^\//, '');
            return this.canLinkToOauth && pathname === 'verification_code';
        },

        _getCurrentHostname: function() {
            return window.location.hostname;
        },

        validateSync: function() {
            var parsed = this._parseUrl(this.val());

            var linkingToOauth = parsed.hostname === this._getCurrentHostname();
            if (!parsed.hostname || (linkingToOauth && !this._isAllowedOauthPathname(parsed.pathname))) {
                return 'invalid';
            }

            if (this.val().length > 1024) {
                return 'toolong';
            }

            return null;
        }
    });

    passport.mixins.validateOnFocusout(url);
})();
