var assert = require('assert');

/**
 * @constructor
 * @class ScopesField
 * @extends Field
 */
module.exports = require('inherit')(require('pform/Field'), {
    __constructor: function() {
        this._init('yandexAppFlag');

        this._corporate = null;
    },

    /**
     * @param {boolean|string} isCorporate     ACCOUNT_IS_CORPORATE BlackBox Attribute
     */
    setUserCorporate: function(isCorporate) {
        assert(typeof isCorporate === 'boolean', 'isCorporate flag should be a boolean');
        this._corporate = isCorporate;
        return this;
    },

    /**
     * @returns {null|boolean}
     */
    isCorporate: function() {
        return this._corporate;
    },

    compile: function(lang, api) {
        assert(typeof lang === 'string' && lang.length === 2,
            'Lang should be a two-letter language code');
        assert(api instanceof require('papi/OAuth'),
            'Api should be an instance of oauth/api');

        var that = this;
        var base = this.__base;
        var args = arguments;
        return api.userInfoV2().then(function(response) {
            if (!response.allowRegisteringYandexClients) {
                that.setHidden();
            }

            return base.apply(that, args);
        });
    },

    getValue: function() {
        return this.__base.apply(this, arguments) === this.__self.CHECKBOX_ON_VALUE;
    }
}, {
    CHECKBOX_ON_VALUE: 'on'
});
