module.exports = require('inherit')(require('pview'), {
    name: 'user',
    __constructor: function(controller) {
        require('assert')(controller instanceof require('../../controller/Controller'), 'Argument should be an instance of Controller');

        this.__base.apply(this, arguments);
        this._controller = controller;
    },

    _compile: function() {
        var auth = this._controller.getAuth();
        return { user: {
            loggedIn: auth.isLoggedIn(),
            username: auth.getDisplayName() || auth.getLogin()
        }};
    }
});
