/**
 * @extends View
 * @typedef MessageView
 * @class MessageView
 */
module.exports = require('inherit')(require('pview'), {
    name: 'message',

    /**
     * @param {string} message  Message localization key
     * @class MessageView
     * @constructor
     */
    __constructor: function(message) {
        require('assert')(message && typeof message === 'string', 'Message localization key should be defined');

        this.__base.apply(this, arguments);

        this._key = message;
        this._args = Array.prototype.slice.call(arguments);
    },

    /**
     * @param {string} lang Two-letter language code
     * @returns {{message: {localized: string, key: string}}}
     * @private
     */
    _compile: function(lang) {
        require('assert')(typeof lang === 'string' && lang.length === 2, 'Lang should be a two-letter language code');

        var i18n = require('putils').i18n;
        return { message: {
            localized: i18n.apply(i18n, [lang].concat(this._args)),
            key: this._key
        } };
    }
});
