#!/bin/bash

rm -rf ./plibs
mv ../plibs .

VERSION=`dpkg-parsechangelog | sed -n 's/^Version: //p'`
cat ./debian/changelog | sed "s/yandex-oauth-frontend/yandex-oauth-frontend-static-$VERSION/" > ./build/client/debian/changelog


echo "Copying dh definitions for version $VERSION"
cp build/client/debian/yandex-oauth-frontend-static.dirs.template debian/yandex-oauth-frontend-static-${VERSION}.dirs
sed -i "s/{{VERSION}}/$VERSION/g" debian/yandex-oauth-frontend-static-${VERSION}.dirs

cp build/client/debian/yandex-oauth-frontend-static.install.template debian/yandex-oauth-frontend-static-${VERSION}.install
sed -i "s/{{VERSION}}/$VERSION/g" debian/yandex-oauth-frontend-static-${VERSION}.install

cp build/client/debian/postinst debian/postinst
sed -i "s/{{VERSION}}/$VERSION/g" debian/postinst
chmod a+x debian/postinst

cp build/client/debian/control debian/control
cp build/client/debian/rules debian/rules
cp build/client/debian/compat debian/compat
cp build/client/debian/changelog debian/changelog

echo "Writing version into debian/control"
sed -i "s/yandex-oauth-frontend-static-/yandex-oauth-frontend-static-$VERSION/g" debian/control

_PWD=`pwd`
_DIR=`basename ${_PWD}`
_PWD=`dirname ${_PWD}`
echo "Building"
build-package-pbuilder ${_DIR} --upload-to verstka --basetgz base-nodejs.tgz --ov-source-path ${_PWD} || exit 3

#echo `conductor-ticket --branch=stable --auth ea4dd09cb1046b72fa2b75c42916e91e yandex-oauth-frontend-static=${VERSION}`
echo `debticket --branch=stable -n`
