#!/bin/sh

VERSION=`git rev-parse --abbrev-ref HEAD`
IS_RELEASE=`echo $VERSION | grep -Po '^(rc\-|hotfix\-)' | wc -m`
if [ "0" = "$IS_RELEASE" ]
then
  # Not a release branch, skip the check
  exit 0
fi

git fetch
BEHIND_DIFF_LENGTH=`git rev-list $VERSION..origin/master | wc -l`
if [ "0" = "$BEHIND_DIFF_LENGTH" ]
then
  exit 0
fi

echo "*************************************************"
echo "This branch is behind master. Merge and rebuild."
echo "*************************************************"
exit 1
