/*
    This is how you write the config:

    host: yandex.ru
    path: /whatso/ever
    url: https://yandex.ru/whatso/ever

    Items should be sorted alphabetically

 */

const url = require('url');
const loc = require('../_common/loc');
const documentationLinks = require('../_common/documentationLinks');
const CSP_NONE = "'none'";
const CSP_SELF = "'self'";
const CSP_UNSAFE_INLINE = "'unsafe-inline'";
const CSP_UNSAFE_EVAL = "'unsafe-eval'";
const CSP_DATA = 'data:';
const CSP_YASTATIC = 'yastatic.net';
const CSP_YANDEX_ST = 'yandex.st';
const CSP_CAPTCHA = '*.captcha.yandex.net';
const CSP_AVATARS_MDS = 'avatars.mds.yandex.net';
const CSP_AVATARS_MDST = 'avatars.mdst.yandex.net';
const CSP_CLCK = 'clck.yandex.ru';
const CSP_STATIC_MAPS = 'static-maps.yandex.ru';
const CSP_YAPIC = 'yapic.yandex.ru';
const CSP_IMG_YANDEX_RU = 'img.yandex.ru';
const CSP_PASSPORT_TEST = 'passport-test.yandex.ru';
const CSP_0_PASSPORT_DEV = '0.passportdev.yandex.ru';
const CSP_METRIC = (_, res) =>
    `mc.yandex.ru${(res.locals.selfTld !== 'ru' && ' mc.yandex.' + res.locals.selfTld) || ''}`;
const CSP_AD_METRICA = 'mc.admetrica.ru';

module.exports = {
    env: 'development',

    api: {
        oauth: {
            dao: {
                baseUrl: 'http://127.0.0.1:8302/iface_api',
                maxRetries: 5,
                maxConnections: 100,
                retryAfter: 100, // Milliseconds to wait before retrying
                retryCodes: ['backend.failed'],
                timeout: 8000
            }
        },
        passport: {
            dao: {
                baseUrl: 'http://passport-test-internal.yandex.ru',
                maxRetries: 5,
                maxConnections: 100,
                retryAfter: 100, // Milliseconds to wait before retrying
                retryCodes: ['blackboxfailed'],
                timeout: 8000
            }
        },
        disk: {
            dao: {
                baseUrl: 'http://sync01g.dst.yandex.net:8090',
                maxRetries: 5,
                maxConnections: 100,
                retryAfter: 100, // Milliseconds to wait before retrying
                timeout: 8000
            }
        }
    },

    avatar: {
        host: 'avatars.yandex.net',
        pathname: '/get-yapic/%uid%/islands-%size%'
    },

    mds: 'https://avatars.mdst.yandex.net/get-yapic/%avatarId%/islands-200',

    csrfSalt: 'jaengahseeDaxoh6OongaiJ0ae8eMi5Bahs0oogeshoiquee2sha9eelaiVi4nee',

    hosts: {
        blackbox: 'pass-test.yandex.ru',
        mda: 'mda-dev.yandex.ru'
    },

    loc,

    loglevel: 'debug',

    paths: {
        static: '/st',
        experiments: 'http://uaas.search.yandex.net/passport',
        passport: process.env.PASSPORT_URL || 'https://passport-test.yandex.%tld%'
    },

    metricsID: '43642384',
    clientMetricsID: '50650357',

    appPasswordsClientIdMapping: {
        ff09aae859654e11bf8048fb94778db6: 'calendar',
        ed55e32b5d2348019f3d986d77fb658b: 'disk',
        e1a4e817569d4e70898becaf663d4068: 'mail',
        '9c6f636360a24598bafb60d5b789b010': 'collector',
        '04ea19418d9c4f1cb82d6d8919e75e0d': 'chat'
    },

    documentationLinks
};

module.exports.helmet = {
    csp: {
        directives: {
            defaultSrc: [CSP_NONE],
            styleSrc: [CSP_SELF, CSP_YASTATIC, CSP_UNSAFE_INLINE, CSP_UNSAFE_EVAL],
            scriptSrc: [
                CSP_SELF,
                CSP_YASTATIC,
                CSP_YANDEX_ST,
                CSP_METRIC,
                CSP_UNSAFE_EVAL,
                (req, res) => `'nonce-${res.locals.nonce}'` // CSPv2 nonce directive for inline scripts
            ],
            imgSrc: [
                CSP_SELF,
                CSP_YASTATIC,
                CSP_YANDEX_ST,
                CSP_METRIC,
                CSP_DATA,
                CSP_CAPTCHA,
                CSP_AVATARS_MDS,
                CSP_AVATARS_MDST,
                CSP_CLCK,
                CSP_YAPIC,
                CSP_IMG_YANDEX_RU,
                CSP_STATIC_MAPS,
                CSP_AD_METRICA
            ],
            fontSrc: [CSP_SELF, CSP_DATA, CSP_YASTATIC],
            objectSrc: [CSP_YASTATIC],
            mediaSrc: [CSP_CAPTCHA, CSP_DATA],
            connectSrc: [
                CSP_SELF,
                CSP_METRIC,
                CSP_0_PASSPORT_DEV,
                (_, res) => `passport-test.yandex.${res.locals.selfTld}`
            ],
            frameSrc: [CSP_SELF, (_, res) => `yandex.${res.locals.selfTld}`],
            childSrc: [CSP_SELF],
            reportUri: function (req) {
                return url.format({
                    protocol: 'https',
                    hostname: 'csp.yandex.net',
                    pathname: 'csp',
                    query: {
                        from: 'oauth',
                        yandex_login: req.cookies.yandex_login,
                        yandexuid: req.cookies.yandexuid
                    }
                });
            }
        },
        reportOnly: false
    },
    frameguard: 'DENY',
    noCache: {
        noEtag: true
    }
};

module.exports.ticketsFile = '/var/cache/yandex/passport-tvm-keyring/oauth-frontend.tickets';
