/*
    This is how you write the config:

    host: yandex.ru
    path: /whatso/ever
    url: https://yandex.ru/whatso/ever

    Items should be sorted alphabetically

 */
const url = require('url');
const loc = require('../_common/loc');
const documentationLinks = require('../_common/documentationLinks');
const CSP_NONE = "'none'";
const CSP_SELF = "'self'";
const CSP_UNSAFE_INLINE = "'unsafe-inline'";
const CSP_UNSAFE_EVAL = "'unsafe-eval'";
const CSP_DATA = 'data:';
const CSP_YASTATIC = 'yastatic.net';
const CSP_YANDEX_ST = 'yandex.st';
const CSP_CAPTCHA = '*.captcha.yandex.net';
const CSP_AVATARS_MDS = 'avatars.mds.yandex.net';
const CSP_AVATARS_MDST = 'avatars.mdst.yandex.net';
const CSP_CLCK = 'clck.yandex.ru';
const CSP_YAPIC = 'yapic.yandex.ru';
const CSP_IMG_YANDEX_RU = 'img.yandex.ru';
const CSP_METRIC = (_, res) =>
    `mc.yandex.ru${(res.locals.selfTld !== 'ru' && ' mc.yandex.' + res.locals.selfTld) || ''}`;
const CSP_PASSPORT = (_, res) => `passport.yandex.${res.locals.selfTld}`;
const CSP_AD_METRICA = 'mc.admetrica.ru';

module.exports = {
    env: 'production',

    api: {
        oauth: {
            dao: {
                baseUrl: 'http://127.0.0.1:8302/iface_api',
                maxRetries: 3,
                maxConnections: 100,
                retryAfter: 500, // Milliseconds to wait before retrying
                retryCodes: ['backend.failed'],
                timeout: 1000
            }
        },
        passport: {
            dao: {
                baseUrl: 'http://passport-internal.yandex.ru',
                maxRetries: 1,
                maxConnections: 100,
                retryAfter: 300, // Milliseconds to wait before retrying
                retryCodes: ['blackboxfailed'],
                timeout: 2000
            }
        },
        disk: {
            dao: {
                baseUrl: 'http://sync.disk.yandex.net:8090',
                maxRetries: 3,
                maxConnections: 100,
                retryAfter: 500, // Milliseconds to wait before retrying
                timeout: 1000
            }
        }
    },

    avatar: {
        host: 'avatars.yandex.net',
        pathname: '/get-yapic/%uid%/islands-%size%'
    },

    mds: 'https://avatars.mds.yandex.net/get-yapic/%avatarId%/islands-200',

    csrfSalt: 'eisheiz8geisahCeiyeegai9Ohgh8cheizaec3oy3ieTieheaque4iY6ooroohei',

    hosts: {
        blackbox: 'blackbox.yandex.net',
        mda: 'pass.yandex.ru'
    },

    loc,

    loglevel: 'info',

    paths: {
        static: 'https://yastatic.net/s3/passport-static/oauth/v{{VERSION}}',
        experiments: 'http://uaas.search.yandex.net/passport',
        passport: 'https://passport.yandex.%tld%/profile'
    },

    metricsID: '43642384',
    clientMetricsID: '50650357',

    appPasswordsClientIdMapping: {
        '773adca0973d47e1a43c36b01ab997d4': 'calendar',
        '8a14a05d50174be6a4475611dd1a7259': 'disk',
        d70555c89e7840ce8de434962014369d: 'mail',
        '122a5db724824fa0ad3788de112acb9b': 'collector',
        fa811d06cb7c44f6b18f13c3e99cec1a: 'chat'
    },

    documentationLinks
};

module.exports.helmet = {
    csp: {
        directives: {
            defaultSrc: [CSP_NONE],
            styleSrc: [CSP_YASTATIC, CSP_UNSAFE_INLINE, CSP_UNSAFE_EVAL],
            scriptSrc: [
                CSP_SELF,
                CSP_YASTATIC,
                CSP_YANDEX_ST,
                CSP_METRIC,
                CSP_UNSAFE_EVAL,
                (req, res) => `'nonce-${res.locals.nonce}'` // CSPv2 nonce directive for inline scripts
            ],
            imgSrc: [
                CSP_YASTATIC,
                CSP_METRIC,
                CSP_YANDEX_ST,
                CSP_DATA,
                CSP_CAPTCHA,
                CSP_AVATARS_MDS,
                CSP_AVATARS_MDST,
                CSP_CLCK,
                CSP_YAPIC,
                CSP_IMG_YANDEX_RU,
                CSP_AD_METRICA
            ],
            fontSrc: [CSP_DATA, CSP_YASTATIC],
            objectSrc: [CSP_YASTATIC],
            mediaSrc: [CSP_CAPTCHA, CSP_DATA],
            connectSrc: [CSP_SELF, CSP_PASSPORT, CSP_METRIC],
            frameSrc: [CSP_SELF, CSP_YANDEX_ST, (_, res) => `yandex.${res.locals.selfTld}`],
            childSrc: [CSP_SELF, CSP_YANDEX_ST],
            reportUri: function (req) {
                return url.format({
                    protocol: 'https',
                    hostname: 'csp.yandex.net',
                    pathname: 'csp',
                    query: {
                        from: 'oauth',
                        yandex_login: req.cookies.yandex_login,
                        yandexuid: req.cookies.yandexuid
                    }
                });
            }
        },
        reportOnly: false
    },
    frameguard: 'DENY',
    noCache: {
        noEtag: true
    }
};

module.exports.ticketsFile = '/var/cache/yandex/passport-tvm-keyring/oauth-frontend.tickets';
