module.exports = function(config) {
    config.set({
        basePath: './',
        frameworks: ['mocha', 'expect', 'sinon'],
        files: [
            "http://yandex.st/jquery/1.9.1/jquery.js",
            "http://yandex.st/underscore/1.5.2/underscore-min.js",

            //Globals
            "test/util/globals.js",

            //Build
            "test/client/_build/blocks.js",

            //Initializing blocks
            "test/client/blocks/initBlocks.js",

            //Specs
            "test/client/blocks/**/*.js"
        ],
        singleRun: true,
        reporters: ['progress'],
        port: 9876,
        colors: true,
        logLevel: config.LOG_INFO,
        browsers: ['PhantomJS'],
        captureTimeout: 60000
    });
};
