const inherit = require('inherit');
const assert = require('assert');
const util = require('util');

module.exports = inherit(Error, {
    /**
     * @param {number} code
     * @param {string} [message]
     * @constructor
     */
    __constructor: function (code, message) {
        assert(code && typeof code === 'number', 'HTTP Error code should be a number');
        assert(!message || typeof message === 'string', 'Error message should be a string if defined');

        this.code = code;
        this.message = message;
        this.__base.call(this, message);

        this.name = 'HTTPException';
    },

    /**
     * Set an explicit name for an HTTPException
     * @param {string} name
     */
    setName: function (name) {
        assert(name && typeof name === 'string', 'Error name should be a string');
        this.name = name;
    },

    toString: function () {
        return util.format('%s %s: %s', this.name, this.code, this.message);
    }
});
