const inherit = require('inherit');
const AbstractPage = require('../AbstractPage');
const config = require('../../config/current');
const util = require('util');

//Redirecting from a legacy url access page lived at the launch to passport
module.exports = inherit(AbstractPage, {
    name: 'profile.access.redirector',

    open: function () {
        this._logger.info('Redirecting to index');

        let passportHost;
        switch (config.env) {
            case 'development':
            case 'testing':
                passportHost = 'passport-test.yandex.';
                break;
            case 'stress':
                passportHost = 'passport-load.yandex.';
                break;
            case 'rc':
                passportHost = 'passport-rc.yandex.';
                break;
            case 'testing-team':
                passportHost = 'passport-test.yandex-team.';
                break;
            case 'rc-team':
                passportHost = 'passport-rc.yandex-team.';
                break;
            case 'production-team':
                passportHost = 'passport.yandex-team.';
                break;
            default:
                passportHost = 'passport.yandex.';
                break;
        }

        return this._controller.redirect(
            util.format('https://%s%s/profile/access?origin=oauth', passportHost, this._controller.getTld())
        );
    }
});
