const inherit = require('inherit');
const AuthorizeLayout = require('./AuthorizeLayout');
const AbstractPage = require('../AbstractPage');
const AuthorizeView = require('./AuthorizeView');

module.exports = inherit(AbstractPage, {
    name: 'authorize.react',

    render: function (res, logger, {requested_scopes: requestedScopes, redirect_uri: redirectUri}) {
        const {responseType, requestId} = res.locals;
        const state = this._controller.getRequestParam('state');

        return new AuthorizeLayout(this._controller)
            .append(
                new AuthorizeView(
                    this._controller,
                    this._api,
                    requestId,
                    requestedScopes,
                    redirectUri,
                    responseType,
                    state
                )
            )
            .render()
            .then((rendered) => {
                logger.verbose('Sending', rendered);
                this._controller.sendPage(rendered);
                logger.info('Page sent');
            });
    }
});
