const inherit = require('inherit');
const Pview = require('pview');
const OauthApi = require('../../../api/oauth/index');

/**
 * Makes a single call to get the edit settings
 * @returns When.Promise
 */
const getSettings = require('lodash').once(function () {
    return new OauthApi('client.edit.settings', {}, 'ru').settings();
});

module.exports = inherit(Pview, {
    name: 'global.settings',

    _compile: function () {
        return getSettings().then((settings) => ({settings}));
    }
});
